/*
 *  Copyright (C) 2006 Simon Funk - simonfunk@gmail.com
 *  
 *  This program is free software; you can redistribute it and/or modify it under 
 *  the terms of the GNU General Public License as published by the Free Software 
 *  Foundation; either version 2 of the License, or (at your option) any later 
 *  version.
 *  
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY 
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 *  PARTICULAR PURPOSE. See the GNU General Public License for more details.
 */

/*
 * This file is a grossly stripped version of my "Toybox" grab-bag of general utilities,
 *  mostly just whatever was needed by Aparse, which in turn is used by joytouch.
 */

#ifndef TOYBOX
#define TOYBOX

#include <math.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>

typedef void  *pointer;
typedef char  *cstring;
typedef double real;

#define salloc(sz) salloc2(sz, __FILE__, __LINE__)

#define stalloc(tp) ((struct tp *)salloc(sizeof (struct tp)))
#define mstalloc(tp,num) ((struct tp *)salloc(sizeof (struct tp) * (long)(num)))
#define zalloc(tp,num) ((tp *)salloc(sizeof(tp)*(long)(num)))
#define talloc(tp) zalloc(tp,1)
#define strsame(a,b) (strncmp(a,b,strlen(a))==0)

#define lfor(ptr,root) for(ptr=root; ptr; ptr=ptr->next)
#define forn(v, n) for((v)=0; (v)<(n); (v)++)
#define fornr(v, n) for((v)=(n)-1; (v)>=0; (v)--)
#define for2(v) forn((v),2)
#define for3(v) forn((v),3)
#define for4(v) forn((v),4)

#define ErLogFile() (stderr)
#define ErFatal(s)        do { fprintf(stderr, s         ); exit(1); } while (0)
#define ErFatal1(s,p)     do { fprintf(stderr, s, p      ); exit(1); } while (0)
#define ErFatal3(s,p,q,r) do { fprintf(stderr, s, p, q, r); exit(1); } while (0)
#define ErCreate(s) do { fprintf(stderr, "%s/%d: %s\n", __FILE__, __LINE__, s); } while (0)

	typedef FILE *File;

	File    fopen_read(cstring);

#define bailout(n) ErShowFatal(n)

cstring filename_extension(cstring s);
int     isoneof(char c,cstring s);

#define Main() int main(int argc, cstring *argv)

static inline pointer salloc2(int sz, cstring file, int line)
{
	pointer mtemp;

	if ((mtemp=malloc(sz)))	// '=' on purpose
		return mtemp;

	ErFatal3("%s/%d: Malloc(%x) returned NULL!",file,line,sz);
	return NULL;
}

static inline cstring crbncpy(cstring s)
{
	if (!s)
		return NULL;

	return strcpy((cstring)salloc(strlen(s)+1), s);
}

#endif

